﻿<%@ Page Title="DoD Fragment Page" Language="C#" MasterPageFile="~/Custom/EFR/Efr.Master" AutoEventWireup="True" CodeBehind="AdminDoDFragment.aspx.cs" Inherits="VIRP_WEB.Custom.EFR.AdminDoDFragment" %>

<%@ Register src="~/Controls/Custom/EFR/BaseControlLabel.ascx" tagname="BaseControlLabel" 
tagprefix="UserControl" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
    <style type="text/css">
        .style1
        {
            width: 15%;
        }
        .style2
        {
            width: 25%;
        }
    </style>
    <script src="scripts/jquery-1[1].3.2.js" type="text/javascript"></script>
    
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

        <asp:GridView ID = "GridViewEFRFragmentsLastExtract" runat = "server" DataKeyNames="DOD_FRAGMENT_RAW_DATA_ID"
        DataSourceID = "ObjectDataSourceDoDFragmentLastExtract" OnRowCommand = "DoDFragment_RowCommand" 
        AutoGenerateColumns = "false" AllowPaging="False" SkinID = "Unsortable" UseAccessibleHeader = "true"
        CssClass="gridRegistry" PagerStyle-CssClass="pager" EmptyDataRowStyle-CssClass="gridRegistryEmpty">
        <EmptyDataTemplate>
            No DoD fragments data exact      
        </EmptyDataTemplate>                     
        <Columns>
            <asp:TemplateField HeaderText = "DoD Fragment ID" ItemStyle-HorizontalAlign="Center" Visible="false">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelDodFragmentRawDataId" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("DOD_FRAGMENT_RAW_DATA_ID"))) %>' ></asp:Label>                 
                </ItemTemplate>    
            </asp:TemplateField>

            <asp:TemplateField AccessibleHeaderText = "DoD Lab" HeaderText = "DoD Lab" >
                <ItemTemplate>
                     <asp:Label ID = "LabelSourceLab" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Source_Lab"))) %>' SkinID = "DataLabel" /> 
                                
                </ItemTemplate>
             </asp:TemplateField>
             
             <asp:TemplateField AccessibleHeaderText = "Last Fragment Extract File Received Date" HeaderText = "Last Fragment Extract File Received Date" ItemStyle-HorizontalAlign="Center">    
                <ItemTemplate>
                    <asp:Label ID = "LabelLastReceivedDate" runat = "server" Text = '<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Convert.ToString(Eval("Created", "{0:M/d/yyyy h:mm:ss tt}"))) %>' SkinID = "DataLabel" />                             
                </ItemTemplate> 
             </asp:TemplateField>    
                
            <asp:ButtonField ButtonType = "Button" Text = "Open / Download" CommandName = "Details"  AccessibleHeaderText = "View File"  />
            
       </Columns> 
        </asp:GridView> 
       <br />        
    <asp:ObjectDataSource ID = "ObjectDataSourceDoDFragmentLastExtract" runat = "server" 
    SelectMethod="GetLastExtractDateForAllLabs"  
        TypeName="VIRP.EFR.DAL.DoDFragmentDB">             
        <SelectParameters>
            <asp:Parameter Name="sortOrder" Type="String" />
            <asp:Parameter Name="orderBy" Type="String" />
            <asp:Parameter Name="filter" Type="String" />
        </SelectParameters>
     </asp:ObjectDataSource>     
    
</asp:Content>